#ifndef FreeMono8pt7b_H
#define FreeMono8pt7b_H

#ifdef __AVR__
#include <avr/io.h>
#include <avr/pgmspace.h>
#elif defined(ESP8266)
#include <pgmspace.h>
#undef PROGMEM
#define PROGMEM STORE_ATTR
#elif defined(__IMXRT1052__) || defined(__IMXRT1062__)
// PROGMEM is defefind for T4 to place data in specific memory section
#undef PROGMEM
#define PROGMEM
#else
#define PROGMEM
#endif

const uint8_t FreeMono8pt7bBitmaps[] PROGMEM = {
  0x00, 0xFE, 0x40, 0x49, 0x24, 0x92, 0x48, 0x14, 0x28, 0x53, 0xF2, 0x44,
  0xBF, 0x94, 0x28, 0x50, 0x00, 0x10, 0x79, 0x12, 0x03, 0x80, 0xC0, 0xC3,
  0xFC, 0x20, 0x30, 0x91, 0x21, 0x80, 0x67, 0x13, 0x09, 0x12, 0x18, 0x39,
  0x04, 0x10, 0x62, 0x59, 0x62, 0x74, 0x49, 0x24, 0x1A, 0xAA, 0xA5, 0x29,
  0x55, 0x6A, 0x20, 0x82, 0x7E, 0x51, 0x20, 0x21, 0x09, 0xF2, 0x10, 0x80,
  0x6B, 0x48, 0xFE, 0xF0, 0x04, 0x10, 0x82, 0x10, 0x42, 0x08, 0x21, 0x04,
  0x20, 0x31, 0x28, 0x61, 0x86, 0x18, 0x61, 0x48, 0xC0, 0x23, 0x28, 0x42,
  0x10, 0x84, 0x27, 0xC0, 0x7B, 0x28, 0x41, 0x08, 0x62, 0x10, 0x83, 0xF0,
  0xF8, 0x18, 0x10, 0x21, 0x80, 0x80, 0x81, 0x84, 0xF0, 0x08, 0xE2, 0x92,
  0x49, 0x28, 0x9F, 0x08, 0x70, 0x78, 0x81, 0x03, 0xE4, 0x60, 0x40, 0x81,
  0xC4, 0x70, 0x3D, 0x84, 0x20, 0xBB, 0x38, 0x61, 0x4C, 0xE0, 0xFC, 0x10,
  0x42, 0x08, 0x21, 0x04, 0x10, 0x80, 0x7B, 0x38, 0x61, 0x79, 0x38, 0x61,
  0xCD, 0xE0, 0x79, 0x8A, 0x0C, 0x1C, 0x6F, 0x40, 0x82, 0x09, 0xE0, 0xF0,
  0x3C, 0x6C, 0x00, 0xD6, 0x80, 0x02, 0x18, 0xC6, 0x06, 0x03, 0x01, 0x80,
  0xFF, 0x00, 0xFF, 0x40, 0x60, 0x30, 0x10, 0xC2, 0x18, 0x00, 0x7A, 0x10,
  0x43, 0x18, 0x80, 0x00, 0x30, 0x38, 0x8A, 0x14, 0xEB, 0x54, 0xA9, 0x4F,
  0x80, 0x80, 0xF0, 0x38, 0x0A, 0x05, 0x04, 0x42, 0x21, 0xF1, 0x04, 0x82,
  0xE3, 0x80, 0xFC, 0x42, 0x42, 0x42, 0x7C, 0x43, 0x41, 0x41, 0xFE, 0x3D,
  0x43, 0x81, 0x80, 0x80, 0x80, 0xC0, 0x61, 0x3E, 0xFC, 0x42, 0x41, 0x41,
  0x41, 0x41, 0x41, 0x42, 0xFC, 0xFE, 0x42, 0x40, 0x48, 0x78, 0x48, 0x40,
  0x41, 0xFF, 0xFF, 0x41, 0x40, 0x48, 0x78, 0x48, 0x40, 0x40, 0xF0, 0x3D,
  0x21, 0xA0, 0x10, 0x08, 0x04, 0x3E, 0x04, 0x82, 0x3E, 0x00, 0xE7, 0x42,
  0x42, 0x42, 0x7E, 0x42, 0x42, 0x42, 0xE7, 0xF9, 0x08, 0x42, 0x10, 0x84,
  0xF8, 0x0F, 0x02, 0x02, 0x02, 0x02, 0x82, 0x82, 0xC6, 0x7C, 0xE7, 0x21,
  0x11, 0x0B, 0x06, 0x82, 0x21, 0x10, 0x84, 0xE1, 0x80, 0xE0, 0x81, 0x02,
  0x04, 0x08, 0x10, 0xA1, 0xFE, 0xE1, 0xD8, 0x65, 0x29, 0x4A, 0x4C, 0x93,
  0x24, 0x09, 0x02, 0xE1, 0xC0, 0xC7, 0x62, 0x62, 0x52, 0x52, 0x4A, 0x4A,
  0x46, 0xE2, 0x3C, 0x42, 0xC3, 0x81, 0x81, 0x81, 0xC3, 0x42, 0x3C, 0xFC,
  0x8D, 0x0A, 0x14, 0x6F, 0x90, 0x20, 0xF0, 0x3C, 0x42, 0xC3, 0x81, 0x81,
  0x81, 0xC3, 0x42, 0x3C, 0x19, 0x26, 0xFC, 0x46, 0x42, 0x46, 0x78, 0x44,
  0x44, 0x42, 0xE1, 0x3A, 0xCD, 0x0A, 0x03, 0xC0, 0x60, 0xE3, 0xBC, 0xFF,
  0x91, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0xE7, 0x42, 0x42, 0x42,
  0x42, 0x42, 0x42, 0x66, 0x3C, 0xE3, 0xA0, 0x90, 0x44, 0x42, 0x20, 0x90,
  0x50, 0x28, 0x08, 0x00, 0xF3, 0x90, 0x24, 0xC9, 0x34, 0x55, 0x14, 0xC5,
  0x30, 0x8C, 0x23, 0x00, 0xC7, 0x42, 0x24, 0x28, 0x10, 0x28, 0x44, 0x42,
  0xE7, 0xE3, 0xA1, 0x08, 0x82, 0x80, 0x80, 0x40, 0x20, 0x10, 0x1C, 0x00,
  0xFA, 0x21, 0x08, 0x21, 0x08, 0x61, 0xFC, 0xEA, 0xAA, 0xAB, 0x82, 0x04,
  0x10, 0x20, 0x81, 0x04, 0x10, 0x20, 0x81, 0xD5, 0x55, 0x57, 0x21, 0x44,
  0xA1, 0xFF, 0xC0, 0x90, 0x7C, 0x02, 0x7E, 0xC2, 0x82, 0x86, 0x7B, 0x81,
  0x02, 0x05, 0xCC, 0x50, 0x60, 0xC1, 0xC5, 0x70, 0x3D, 0x43, 0x81, 0x80,
  0x80, 0x40, 0x3F, 0x02, 0x02, 0x02, 0x3A, 0x46, 0x82, 0x82, 0x82, 0x46,
  0x3B, 0x3C, 0x86, 0x0F, 0xF8, 0x08, 0x4F, 0x00, 0x3A, 0x11, 0xF4, 0x21,
  0x08, 0x47, 0x80, 0x3A, 0x8E, 0x0C, 0x18, 0x28, 0xCE, 0x81, 0x02, 0x38,
  0x40, 0x40, 0x40, 0x5C, 0x62, 0x42, 0x42, 0x42, 0x42, 0xE7, 0x20, 0x18,
  0x42, 0x10, 0x84, 0xF8, 0x20, 0xF1, 0x11, 0x11, 0x11, 0x1E, 0x81, 0x02,
  0x04, 0xE9, 0x14, 0x38, 0x48, 0x89, 0x1C, 0x61, 0x08, 0x42, 0x10, 0x84,
  0x27, 0xC0, 0xB6, 0xC9, 0x89, 0x89, 0x89, 0x89, 0xC9, 0x5C, 0x62, 0x42,
  0x42, 0x42, 0x42, 0xE7, 0x3C, 0x42, 0x81, 0x81, 0x81, 0x42, 0x3C, 0xDC,
  0x62, 0x41, 0x41, 0x41, 0x62, 0x5C, 0x40, 0x40, 0xE0, 0x3B, 0x46, 0x82,
  0x82, 0x82, 0x46, 0x3A, 0x02, 0x02, 0x07, 0xCC, 0xE1, 0x02, 0x04, 0x08,
  0x3C, 0x00, 0x3D, 0x14, 0x0E, 0x06, 0x1F, 0x80, 0x40, 0x83, 0xE2, 0x04,
  0x08, 0x10, 0x21, 0x3C, 0x8E, 0x18, 0x61, 0x86, 0x37, 0x40, 0xF3, 0x90,
  0x88, 0x84, 0x41, 0x40, 0xA0, 0x30, 0xE3, 0xA0, 0x92, 0x46, 0xA3, 0x51,
  0xB0, 0x88, 0xE6, 0x44, 0x28, 0x10, 0x2C, 0x42, 0xE7, 0xE7, 0x42, 0x44,
  0x24, 0x28, 0x18, 0x10, 0x10, 0x20, 0xF0, 0xFA, 0x21, 0x08, 0x42, 0x07,
  0xC0, 0x69, 0x25, 0x12, 0x49, 0x30, 0xFF, 0xF0, 0xC9, 0x24, 0x52, 0x49,
  0x60, 0x60, 0xA4, 0x30 };

const GFXglyph FreeMono8pt7bGlyphs[] PROGMEM = {
  {     0,   1,   1,  10,    0,    0 },   // 0x20 ' '
  {     1,   1,  10,  10,    4,   -9 },   // 0x21 '!'
  {     3,   6,   5,  10,    2,   -9 },   // 0x22 '"'
  {     7,   7,  11,  10,    1,   -9 },   // 0x23 '#'
  {    17,   7,  10,  10,    1,   -9 },   // 0x24 '$'
  {    26,   7,  10,  10,    1,   -9 },   // 0x25 '%'
  {    35,   6,   9,  10,    2,   -8 },   // 0x26 '&'
  {    42,   3,   5,  10,    3,   -9 },   // 0x27 '''
  {    44,   2,  12,  10,    5,   -9 },   // 0x28 '('
  {    47,   2,  12,  10,    3,   -9 },   // 0x29 ')'
  {    50,   6,   6,  10,    2,   -9 },   // 0x2A '*'
  {    55,   5,   7,  10,    2,   -7 },   // 0x2B '+'
  {    60,   3,   5,  10,    2,   -2 },   // 0x2C ','
  {    62,   7,   1,  10,    1,   -4 },   // 0x2D '-'
  {    63,   2,   2,  10,    4,   -1 },   // 0x2E '.'
  {    64,   6,  12,  10,    2,  -10 },   // 0x2F '/'
  {    73,   6,  10,  10,    2,   -9 },   // 0x30 '0'
  {    81,   5,  10,  10,    2,   -9 },   // 0x31 '1'
  {    88,   6,  10,  10,    2,   -9 },   // 0x32 '2'
  {    96,   7,  10,  10,    1,   -9 },   // 0x33 '3'
  {   105,   6,  10,  10,    2,   -9 },   // 0x34 '4'
  {   113,   7,  10,  10,    1,   -9 },   // 0x35 '5'
  {   122,   6,  10,  10,    2,   -9 },   // 0x36 '6'
  {   130,   6,  10,  10,    2,   -9 },   // 0x37 '7'
  {   138,   6,  10,  10,    2,   -9 },   // 0x38 '8'
  {   146,   7,  10,  10,    2,   -9 },   // 0x39 '9'
  {   155,   2,   7,  10,    4,   -6 },   // 0x3A ':'
  {   157,   3,   9,  10,    2,   -6 },   // 0x3B ';'
  {   161,   7,   7,  10,    1,   -7 },   // 0x3C '<'
  {   168,   8,   3,  10,    1,   -5 },   // 0x3D '='
  {   171,   7,   7,  10,    1,   -7 },   // 0x3E '>'
  {   178,   6,   9,  10,    2,   -8 },   // 0x3F '?'
  {   185,   7,  11,  10,    2,   -9 },   // 0x40 '@'
  {   195,   9,   9,  10,    0,   -8 },   // 0x41 'A'
  {   206,   8,   9,  10,    1,   -8 },   // 0x42 'B'
  {   215,   8,   9,  10,    1,   -8 },   // 0x43 'C'
  {   224,   8,   9,  10,    1,   -8 },   // 0x44 'D'
  {   233,   8,   9,  10,    1,   -8 },   // 0x45 'E'
  {   242,   8,   9,  10,    1,   -8 },   // 0x46 'F'
  {   251,   9,   9,  10,    1,   -8 },   // 0x47 'G'
  {   262,   8,   9,  10,    1,   -8 },   // 0x48 'H'
  {   271,   5,   9,  10,    2,   -8 },   // 0x49 'I'
  {   277,   8,   9,  10,    1,   -8 },   // 0x4A 'J'
  {   286,   9,   9,  10,    1,   -8 },   // 0x4B 'K'
  {   297,   7,   9,  10,    2,   -8 },   // 0x4C 'L'
  {   305,  10,   9,  10,    0,   -8 },   // 0x4D 'M'
  {   317,   8,   9,  10,    1,   -8 },   // 0x4E 'N'
  {   326,   8,   9,  10,    1,   -8 },   // 0x4F 'O'
  {   335,   7,   9,  10,    1,   -8 },   // 0x50 'P'
  {   343,   8,  11,  10,    1,   -8 },   // 0x51 'Q'
  {   354,   8,   9,  10,    1,   -8 },   // 0x52 'R'
  {   363,   7,   9,  10,    1,   -8 },   // 0x53 'S'
  {   371,   8,   9,  10,    1,   -8 },   // 0x54 'T'
  {   380,   8,   9,  10,    1,   -8 },   // 0x55 'U'
  {   389,   9,   9,  10,    0,   -8 },   // 0x56 'V'
  {   400,  10,   9,  10,    0,   -8 },   // 0x57 'W'
  {   412,   8,   9,  10,    1,   -8 },   // 0x58 'X'
  {   421,   9,   9,  10,    1,   -8 },   // 0x59 'Y'
  {   432,   6,   9,  10,    2,   -8 },   // 0x5A 'Z'
  {   439,   2,  12,  10,    4,   -9 },   // 0x5B '['
  {   442,   6,  12,  10,    2,  -10 },   // 0x5C '\'
  {   451,   2,  12,  10,    3,   -9 },   // 0x5D ']'
  {   454,   6,   4,  10,    2,   -9 },   // 0x5E '^'
  {   457,  10,   1,  10,    0,    2 },   // 0x5F '_'
  {   459,   2,   2,  10,    2,   -9 },   // 0x60 '`'
  {   460,   8,   7,  10,    1,   -6 },   // 0x61 'a'
  {   467,   7,  10,  10,    2,   -9 },   // 0x62 'b'
  {   476,   8,   7,  10,    1,   -6 },   // 0x63 'c'
  {   483,   8,  10,  10,    1,   -9 },   // 0x64 'd'
  {   493,   7,   7,  10,    1,   -6 },   // 0x65 'e'
  {   500,   5,  10,  10,    3,   -9 },   // 0x66 'f'
  {   507,   7,  10,  10,    1,   -6 },   // 0x67 'g'
  {   516,   8,  10,  10,    1,   -9 },   // 0x68 'h'
  {   526,   5,   9,  10,    2,   -8 },   // 0x69 'i'
  {   532,   4,  12,  10,    3,   -8 },   // 0x6A 'j'
  {   538,   7,  10,  10,    2,   -9 },   // 0x6B 'k'
  {   547,   5,  10,  10,    2,   -9 },   // 0x6C 'l'
  {   554,   8,   7,  10,    1,   -6 },   // 0x6D 'm'
  {   561,   8,   7,  10,    1,   -6 },   // 0x6E 'n'
  {   568,   8,   7,  10,    1,   -6 },   // 0x6F 'o'
  {   575,   8,  10,  10,    1,   -6 },   // 0x70 'p'
  {   585,   8,  10,  10,    1,   -6 },   // 0x71 'q'
  {   595,   7,   7,  10,    2,   -6 },   // 0x72 'r'
  {   602,   6,   7,  10,    2,   -6 },   // 0x73 's'
  {   608,   7,   9,  10,    1,   -8 },   // 0x74 't'
  {   616,   6,   7,  10,    2,   -6 },   // 0x75 'u'
  {   622,   9,   7,  10,    0,   -6 },   // 0x76 'v'
  {   630,   9,   7,  10,    0,   -6 },   // 0x77 'w'
  {   638,   8,   7,  10,    1,   -6 },   // 0x78 'x'
  {   645,   8,  10,  10,    1,   -6 },   // 0x79 'y'
  {   655,   6,   7,  10,    2,   -6 },   // 0x7A 'z'
  {   661,   3,  12,  10,    4,   -9 },   // 0x7B '{'
  {   666,   1,  12,  10,    4,   -9 },   // 0x7C '|'
  {   668,   3,  12,  10,    3,   -9 },   // 0x7D '}'
  {   673,   7,   3,  10,    1,   -5 } }; // 0x7E '~'

const GFXfont FreeMono8pt7b PROGMEM = {
  (uint8_t  *)FreeMono8pt7bBitmaps,
  (GFXglyph *)FreeMono8pt7bGlyphs,
  0x20, 0x7E, 16 };

// Approx. 1348 bytes

#endif // FreeMono8pt7b_H
